local cpus = {
	blanc = "epic",
	nepgear = "legendary",
	neptune = "epic",
	noire = "epic",
	peashy = "uncommon",
	plutia = "uncommon",
	ram = "rare",
	rom = "rare",
	uni = "rare",
	vert = "epic"
}

Hooks:PostHook( EconomyTweakData, "_init_armor_skins", "HyperdimensionArmorSkins", function(self)
	for cpu, rarity in pairs( cpus ) do
		self.armor_skins[cpu] = {
			name_id = "bm_askn_" .. cpu,
			desc_id = "bm_askn_" .. cpu .. "_desc",
			rarity = rarity,
			reserve_quality = false,
			steam_economy = false,
			free = true,
			unlocked = true,
			texture_bundle_folder = "hyperdimension",

			category = "hyperdimension",

			base_gradient = {
				[2] = Idstring("units/payday2_cash/safes/cvc/base_gradient/base_cvc_001_df"),
				[3] = Idstring("units/payday2_cash/safes/cvc/base_gradient/base_cvc_001_df")
			},
			sticker = {
				[2] = Idstring("units/hyperdimension/armor_skins/stickers/" .. cpu),
				[3] = Idstring("units/hyperdimension/armor_skins/stickers/" .. cpu)
			},
			pattern_pos = {
				[2] = Vector3(-0.213212, 0.454567, 0),
				[3] = Vector3(0.04436, 0, 0),
			},
			uv_scale = {
				[2] = Vector3(0.391396, 0.868143, 0),
				[3] = Vector3(0.963492, 0.963492, 0)
			},
			uv_offset_rot = {
				[2] = Vector3(0.025, 1.6, 3.14),
				[3] = Vector3(0.263773, 0.578584, 0)
			}
		}
	end
end)